using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.IO;

namespace FTPHelper
{
    [Serializable]
    public class FTPConnection
    {
        string _username;
        string _password;
        public string _url;


        public FTPConnection()
        {
            
        }

        public FTPConnection(string ftpurl, string userName, string password)
        {
            _username = userName;
            _password = password;
            _url = "ftp://"+ftpurl;
        }

        public FtpWebRequest ConnectToFtp(string Method)
        {
            FtpWebRequest ftpRequest = (FtpWebRequest)FtpWebRequest.Create(new Uri(_url));
            ftpRequest.UseBinary = true;
            ftpRequest.Credentials = new NetworkCredential(_username, _password);
            ftpRequest.Method = Method;

            ftpRequest.Proxy = null;
            ftpRequest.KeepAlive = false;
            ftpRequest.UsePassive = false;
            return ftpRequest;
        }

        /// <summary>
        /// Connect to ftp on specfic Url and related method
        /// </summary>
        /// <param name="SpecificPathOnFtpUrl"></param>
        /// <param name="Method"></param>
        /// <returns></returns>
        public FtpWebRequest ConnectToFtp(string SpecificPathOnFtpUrl, string Method)
        {
            FtpWebRequest ftpRequest = (FtpWebRequest)FtpWebRequest.Create(new Uri(SpecificPathOnFtpUrl));
            ftpRequest.UseBinary = true;
            ftpRequest.Credentials = new NetworkCredential(_username, _password);
            ftpRequest.Method = Method;

            ftpRequest.Proxy = null;
            ftpRequest.KeepAlive = false;
            ftpRequest.UsePassive = false;
            return ftpRequest;
        }

        /// <summary>
        /// Get all files in ftp folder
        /// </summary>
        /// <param name="FolderUrl"></param>
        /// <returns></returns>
        public Dictionary<string, string> GetFileList(string FolderUrl)
        {
            StringBuilder filesstring = new StringBuilder();
            WebResponse webResponse = null;
            StreamReader sreader = null;
            Dictionary<string, string> Files = new Dictionary<string, string>();
            try
            {
                //you can change url to connect to ftp according to your need
                FtpWebRequest ftpRequest = ConnectToFtp(FolderUrl, WebRequestMethods.Ftp.ListDirectory);

                webResponse = ftpRequest.GetResponse();
                sreader = new StreamReader(webResponse.GetResponseStream());
                string strline = sreader.ReadLine();
                while (strline != null)
                {
                    Files.Add(strline, FolderUrl +"/"+ strline);
                    strline = sreader.ReadLine();
                }         
               
                return Files;
            }
            catch (Exception ex)
            {
                //do any thing with exception
                return null;
            }
            finally
            {
                if (sreader != null)
                {
                    sreader.Close();
                }
                if (webResponse != null)
                {
                    webResponse.Close();
                }
            }
        }

     
        
        /// <summary>
        /// Download file from ftp and save at local path
        /// </summary>
        /// <param name="fileUrl"></param>
        /// <param name="localPath"></param>
        public void DownloadFileFromFtp(string fileUrl, string localPath)
        {
            StringBuilder filesstring = new StringBuilder();
            WebResponse webResponse = null;
            try
            {
                FtpWebRequest ftpRequest = ConnectToFtp(fileUrl, WebRequestMethods.Ftp.DownloadFile);
                ftpRequest.UseBinary = true;
                webResponse = ftpRequest.GetResponse();

                FtpWebResponse response = (FtpWebResponse)ftpRequest.GetResponse();
                Stream dfileResponseStream = response.GetResponseStream();
                FileStream dfileWriteStream = new FileStream(localPath, FileMode.Create);
                
                int Length = 8192;
                Byte[] buffer = new Byte[Length];
                int bytesRead = dfileResponseStream.Read(buffer, 0, Length);
                while (bytesRead > 0)
                {
                    dfileWriteStream.Write(buffer, 0, bytesRead);
                    bytesRead = dfileResponseStream.Read(buffer, 0, Length);
                }
                dfileWriteStream.Close();
                response.Close();
                Console.WriteLine("File download sucessfully");
            }
            catch (Exception ex)
            {
                //do any thing with exception
            }
            finally
            {
                if (webResponse != null)
                {
                    webResponse.Close();
                }
            }
        }

        /// <summary>
        /// Download file with http response
        /// </summary>
        /// <param name="fileUrl"></param>
        /// <param name="localPath"></param>
        public byte[] DownloadFileFromFtp(string fileUrl)
        {
            StringBuilder filesstring = new StringBuilder();
            WebResponse webResponse = null;
            try
            {
                FtpWebRequest ftpRequest = ConnectToFtp(fileUrl, WebRequestMethods.Ftp.DownloadFile);
                ftpRequest.UseBinary = true;
                webResponse = ftpRequest.GetResponse();

                FtpWebResponse response = (FtpWebResponse)webResponse;
                
                Stream dfileResponseStream = response.GetResponseStream();
                
                
                int Length = 1024;
                
                Byte[] buffer = new Byte[Length];
                List<byte> filebytes = new List<byte>();
                int bytesRead = dfileResponseStream.Read(buffer, 0, Length);
                while (bytesRead > 0)
                {
                    for(int i= 0;i<bytesRead;i++)
                        filebytes.Add(buffer[i]);
                    
                    bytesRead = dfileResponseStream.Read(buffer, 0, Length);
                }
                response.Close();
                return filebytes.ToArray();
            }
            catch (Exception ex)
            {
                //do any thing with exception
                return null;
            }
            finally
            {
                if (webResponse != null)
                {
                    webResponse.Close();
                }
            }
        }

    }
}
